<?php
namespace App\Controllers\Admin;
use App\Models\PriceList;
use App\Models\PriceListItem;
use App\Models\Product;

class PriceListsController {
    public function __construct(private array $config){}

    public function index(){
        $items = PriceList::all();
        include __DIR__ . '/../../Views/admin/pricelists/index.php';
    }

    public function createForm(){ include __DIR__ . '/../../Views/admin/pricelists/create.php'; }

    public function create($req,$res){
        $name = trim($_POST['name'] ?? '');
        $currency = trim($_POST['currency'] ?? 'USD');
        $is_default = isset($_POST['is_default']) ? 1 : 0;
        if($name===''){ $_SESSION['error']='Name is required'; return $res->redirect('/admin/pricelists/create'); }
        PriceList::create($name,$currency,$is_default);
        $_SESSION['flash']='Price list created'; return $res->redirect('/admin/pricelists');
    }

    public function editForm(){
        $id = (int)($_GET['id'] ?? 0);
        $item = PriceList::find($id);
        if(!$item){ http_response_code(404); echo 'Not found'; return; }
        $rows = PriceListItem::forList($id);
        $products = Product::all();
        include __DIR__ . '/../../Views/admin/pricelists/edit.php';
    }

    public function update($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $currency = trim($_POST['currency'] ?? 'USD');
        $is_default = isset($_POST['is_default']) ? 1 : 0;
        if($id<=0 || $name===''){ $_SESSION['error']='Invalid'; return $res->redirect('/admin/pricelists'); }
        PriceList::update($id,$name,$currency,$is_default);
        $_SESSION['flash']='Price list updated'; return $res->redirect('/admin/pricelists/edit?id='+$id);
    }

    public function upsertItem($req,$res){
        $pl = (int)($_POST['price_list_id'] ?? 0);
        $pid = (int)($_POST['product_id'] ?? 0);
        $price = (float)($_POST['price'] ?? 0);
        $minq = (int)($_POST['min_qty'] ?? 1);
        if($pl>0 && $pid>0 && $price>=0){ PriceListItem::upsert($pl,$pid,$price,$minq); $_SESSION['flash']='Item saved'; }
        return $res->redirect('/admin/pricelists/edit?id='.$pl);
    }

    public function deleteItem($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        $pl = (int)($_POST['price_list_id'] ?? 0);
        if($id>0){ PriceListItem::delete($id); $_SESSION['flash']='Item deleted'; }
        return $res->redirect('/admin/pricelists/edit?id='.$pl);
    }

    public function delete($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        if($id>0){ PriceList::delete($id); $_SESSION['flash']='Price list deleted'; }
        return $res->redirect('/admin/pricelists');
    }
}
