<?php
namespace App\Models;
use App\Core\DB;
use PDO;

class OrderModel {
    public static function createOrder(array $data, array $items): int {
        $pdo = DB::$pdo;
        $pdo->beginTransaction();
        try {
            $st = $pdo->prepare("INSERT INTO orders (order_number,user_id,customer_id,company_id,rep_id,type,status,subtotal,discount_total,tax_total,shipping_total,grand_total,currency,bill_to_address_id,ship_to_address_id,po_number,placed_at,updated_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
            $st->execute(['', $data['user_id'] ?? null, $data['customer_id'] ?? null, $data['company_id'] ?? null, $data['rep_id'] ?? null, $data['type'] ?? 'retail', $data['status'] ?? 'pending', $data['subtotal'] ?? 0, $data['discount_total'] ?? 0, $data['tax_total'] ?? 0, $data['shipping_total'] ?? 0, $data['grand_total'] ?? 0, $data['currency'] ?? 'USD', $data['bill_to_address_id'] ?? null, $data['ship_to_address_id'] ?? null, $data['po_number'] ?? null]);
            $order_id = (int)$pdo->lastInsertId();
            $order_number = date('Ymd') . '-' . str_pad((string)$order_id, 4, '0', STR_PAD_LEFT);
            $pdo->prepare("UPDATE orders SET order_number=? WHERE id=?")->execute([$order_number, $order_id]);

            $ins = $pdo->prepare("INSERT INTO order_items (order_id,product_id,sku,name,qty,uom,price,discount,tax,line_total) VALUES (?,?,?,?,?,?,?,?,?,?)");
            for ($i=0; $i<count($items); $i++) {
                $it = $items[$i];
                $line_total = ($it['price'] - ($it['discount'] ?? 0)) * $it['qty'];
                $ins->execute([$order_id, $it['product_id'] ?? null, $it['sku'], $it['name'], $it['qty'], $it['uom'] ?? 'ea', $it['price'], $it['discount'] ?? 0, $it['tax'] ?? 0, $line_total]);
            }

            $q = $pdo->prepare("INSERT INTO sync_jobs (entity, entity_id, direction, status, created_at, updated_at) VALUES ('order', ?, 'push', 'queued', NOW(), NOW())");
            $q->execute([$order_id]);

            $pdo->commit();
            return $order_id;
        } catch (\Throwable $e) {
            $pdo->rollBack();
            throw $e;
        }
    }

    public static function getRecentOrdersByUser(int $user_id, int $limit = 20): array {
        $st = DB::$pdo->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY placed_at DESC LIMIT ?");
        $st->bindValue(1, $user_id, PDO::PARAM_INT);
        $st->bindValue(2, $limit, PDO::PARAM_INT);
        $st->execute();
        return $st->fetchAll();
    }
}
