<?php $title='Products'; ob_start(); ?>
<h1>Products</h1>
<?php if(!empty($_SESSION['flash'])): ?><div class="alert"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div><?php endif; ?>
<a class="btn btn-primary" href="<?= app_url('admin/products/create') ?>">New Product</a>
<table class="table" style="width:100%;margin-top:1rem;border-collapse:collapse">
  <tr><th style="text-align:left">SKU</th><th>Name</th><th>Price</th><th>Status</th><th style="width:220px">Actions</th></tr>
  <?php foreach($items as $p): ?>
  <tr>
    <td><?= htmlspecialchars($p['sku']) ?></td>
    <td><?= htmlspecialchars($p['name']) ?></td>
    <td>$<?= number_format((float)$p['base_price'],2) ?></td>
    <td><?= htmlspecialchars($p['status']) ?></td>
    <td>
      <a class="btn" href="<?= app_url('admin/products/edit?id='.$p['id']) ?>">Edit</a>
      <form method="post" action="<?= app_url('admin/products/delete') ?>" style="display:inline" onsubmit="return confirm('Delete this product?')">
        <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
        <button class="btn">Delete</button>
      </form>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
