<?php $title='Edit Product'; ob_start(); ?>
<h1>Edit Product</h1>
<?php if(!empty($_SESSION['error'])): ?><div class="alert"><?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div><?php endif; ?>
<form method="post" action="<?= app_url('admin/products/update') ?>" class="card">
  <input type="hidden" name="id" value="<?= (int)$item['id'] ?>">
  <div class="grid grid-2">
    <div><label>SKU</label><input name="sku" value="<?= htmlspecialchars($item['sku']) ?>" required></div>
    <div><label>Name</label><input name="name" value="<?= htmlspecialchars($item['name']) ?>" required></div>
  </div>
  <label>Description</label><input name="description" value="<?= htmlspecialchars($item['description'] ?? '') ?>">
  <div class="grid grid-2">
    <div><label>UOM</label><input name="uom" value="<?= htmlspecialchars($item['uom']) ?>"></div>
    <div><label>Base Price</label><input name="base_price" type="number" step="0.01" value="<?= htmlspecialchars($item['base_price']) ?>"></div>
  </div>
  <div class="grid grid-2">
    <div><label>Tax Class</label><input name="tax_class" value="<?= htmlspecialchars($item['tax_class'] ?? '') ?>"></div>
    <div><label>Barcode</label><input name="barcode" value="<?= htmlspecialchars($item['barcode'] ?? '') ?>"></div>
  </div>
  <div class="grid grid-2">
    <div><label>Weight</label><input name="weight" type="number" step="0.001" value="<?= htmlspecialchars($item['weight'] ?? '') ?>"></div>
    <div>
      <label>Status</label>
      <select name="status">
        <option value="active" <?= $item['status']==='active'?'selected':'' ?>>active</option>
        <option value="inactive" <?= $item['status']==='inactive'?'selected':'' ?>>inactive</option>
      </select>
    </div>
  </div>
  <label>Categories</label>
  <select name="categories[]" multiple size="5">
    <?php foreach($categories as $c): $selAttr = in_array($c['id'],$sel) ? 'selected' : ''; ?>
      <option value="<?= (int)$c['id'] ?>" <?= $selAttr ?>><?= htmlspecialchars($c['name']) ?></option>
    <?php endforeach; ?>
  </select>
  <button class="btn btn-primary">Save</button>
</form>
<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
