<?php $title='Create Product'; ob_start(); ?>
<h1>New Product</h1>
<?php if(!empty($_SESSION['error'])): ?><div class="alert"><?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div><?php endif; ?>
<form method="post" action="<?= app_url('admin/products/create') ?>" class="card">
  <div class="grid grid-2">
    <div><label>SKU</label><input name="sku" required></div>
    <div><label>Name</label><input name="name" required></div>
  </div>
  <label>Description</label><input name="description">
  <div class="grid grid-2">
    <div><label>UOM</label><input name="uom" value="ea"></div>
    <div><label>Base Price</label><input name="base_price" type="number" step="0.01" value="0.00"></div>
  </div>
  <div class="grid grid-2">
    <div><label>Tax Class</label><input name="tax_class"></div>
    <div><label>Barcode</label><input name="barcode"></div>
  </div>
  <div class="grid grid-2">
    <div><label>Weight</label><input name="weight" type="number" step="0.001"></div>
    <div>
      <label>Status</label>
      <select name="status"><option value="active">active</option><option value="inactive">inactive</option></select>
    </div>
  </div>
  <label>Categories</label>
  <select name="categories[]" multiple size="5">
    <?php foreach($categories as $c): ?>
      <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
    <?php endforeach; ?>
  </select>
  <button class="btn btn-primary">Create</button>
</form>
<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
