<?php $title='Edit Price List'; ob_start(); ?>
<h1>Edit Price List</h1>
<?php if(!empty($_SESSION['flash'])): ?><div class="alert"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div><?php endif; ?>
<form method="post" action="<?= app_url('admin/pricelists/update') ?>" class="card">
  <input type="hidden" name="id" value="<?= (int)$item['id'] ?>">
  <div class="grid grid-2">
    <div><label>Name</label><input name="name" value="<?= htmlspecialchars($item['name']) ?>" required></div>
    <div><label>Currency</label><input name="currency" value="<?= htmlspecialchars($item['currency']) ?>"></div>
  </div>
  <label><input type="checkbox" name="is_default" value="1" <?= !empty($item['is_default'])?'checked':'' ?>> Default</label>
  <button class="btn btn-primary">Save</button>
</form>

<h2 style="margin-top:1.5rem">Entries</h2>
<form method="post" action="<?= app_url('admin/pricelists/items/upsert') ?>" class="card">
  <input type="hidden" name="price_list_id" value="<?= (int)$item['id'] ?>">
  <div class="grid grid-2">
    <div>
      <label>Product</label>
      <select name="product_id">
        <?php foreach($products as $p): ?>
          <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars($p['sku'].' — '.$p['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div><label>Price</label><input type="number" step="0.01" name="price" required></div>
  </div>
  <div><label>Min Qty</label><input type="number" name="min_qty" value="1"></div>
  <button class="btn btn-primary">Add/Update</button>
</form>

<table class="table" style="width:100%;margin-top:1rem;border-collapse:collapse">
  <tr><th style="text-align:left">SKU</th><th>Name</th><th>Price</th><th>Min Qty</th><th style="width:140px">Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= htmlspecialchars($r['sku']) ?></td>
    <td><?= htmlspecialchars($r['name']) ?></td>
    <td>$<?= number_format((float)$r['price'],2) ?></td>
    <td><?= (int)$r['min_qty'] ?></td>
    <td>
      <form method="post" action="<?= app_url('admin/pricelists/items/delete') ?>" onsubmit="return confirm('Delete item?')" style="display:inline">
        <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
        <input type="hidden" name="price_list_id" value="<?= (int)$item['id'] ?>">
        <button class="btn">Delete</button>
      </form>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
