<?php
namespace App\Controllers\Admin;
use App\Models\Product;
use App\Models\Category;
use App\Core\DB;

class ProductsController {
    public function __construct(private array $config){}

    public function index(){
        $items = Product::all();
        include __DIR__ . '/../../Views/admin/products/index.php';
    }

    public function createForm(){
        $categories = Category::all();
        include __DIR__ . '/../../Views/admin/products/create.php';
    }

    public function create($req,$res){
        $data = [
            'sku'=>trim($_POST['sku'] ?? ''),
            'name'=>trim($_POST['name'] ?? ''),
            'description'=>trim($_POST['description'] ?? ''),
            'uom'=>trim($_POST['uom'] ?? 'ea'),
            'base_price'=> (float)($_POST['base_price'] ?? 0),
            'tax_class'=>trim($_POST['tax_class'] ?? ''),
            'barcode'=>trim($_POST['barcode'] ?? ''),
            'weight'=> ($_POST['weight'] === '' ? null : (float)$_POST['weight']),
            'status'=> $_POST['status'] ?? 'active'
        ];
        if($data['sku']==='' || $data['name']===''){ $_SESSION['error']='SKU and Name are required'; return $res->redirect('/admin/products/create'); }
        $product_id = Product::create($data);

        $cat_ids = $_POST['categories'] ?? [];
        if (!is_array($cat_ids)) $cat_ids = [$cat_ids];
        DB::$pdo->prepare("DELETE FROM product_categories WHERE product_id=?")->execute([$product_id]);
        $ins = DB::$pdo->prepare("INSERT INTO product_categories (product_id, category_id) VALUES (?,?)");
        foreach($cat_ids as $cid){ if((int)$cid>0){ $ins->execute([$product_id,(int)$cid]); } }

        $_SESSION['flash']='Product created'; return $res->redirect('/admin/products');
    }

    public function editForm(){
        $id = (int)($_GET['id'] ?? 0);
        $item = Product::find($id);
        if(!$item){ http_response_code(404); echo 'Not found'; return; }
        $categories = Category::all();
        $selected = DB::$pdo->prepare("SELECT category_id FROM product_categories WHERE product_id=?");
        $selected->execute([$id]); $sel = array_column($selected->fetchAll(), 'category_id');
        include __DIR__ . '/../../Views/admin/products/edit.php';
    }

    public function update($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        if($id<=0){ $_SESSION['error']='Invalid product'; return $res->redirect('/admin/products'); }
        $data = [
            'sku'=>trim($_POST['sku'] ?? ''),
            'name'=>trim($_POST['name'] ?? ''),
            'description'=>trim($_POST['description'] ?? ''),
            'uom'=>trim($_POST['uom'] ?? 'ea'),
            'base_price'=> (float)($_POST['base_price'] ?? 0),
            'tax_class'=>trim($_POST['tax_class'] ?? ''),
            'barcode'=>trim($_POST['barcode'] ?? ''),
            'weight'=> ($_POST['weight'] === '' ? null : (float)$_POST['weight']),
            'status'=> $_POST['status'] ?? 'active'
        ];
        if($data['sku']==='' || $data['name']===''){ $_SESSION['error']='SKU and Name are required'; return $res->redirect('/admin/products/edit?id='.$id); }
        Product::update($id,$data);
        $cat_ids = $_POST['categories'] ?? [];
        if (!is_array($cat_ids)) $cat_ids = [$cat_ids];
        DB::$pdo->prepare("DELETE FROM product_categories WHERE product_id=?")->execute([$id]);
        $ins = DB::$pdo->prepare("INSERT INTO product_categories (product_id, category_id) VALUES (?,?)");
        for($i=0;$i<count($cat_ids);$i++){ $cid=(int)$cat_ids[$i]; if($cid>0){ $ins->execute([$id,$cid]); } }
        $_SESSION['flash']='Product updated'; return $res->redirect('/admin/products');
    }

    public function delete($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        if($id>0){ Product::delete($id); $_SESSION['flash']='Product deleted'; }
        return $res->redirect('/admin/products');
    }
}
