<?php
namespace App\Controllers\Admin;
use App\Models\Category;

class CategoriesController {
    public function __construct(private array $config){}

    public function index(){
        $items = Category::all();
        include __DIR__ . '/../../Views/admin/categories/index.php';
    }

    public function createForm(){ include __DIR__ . '/../../Views/admin/categories/create.php'; }

    public function create($req,$res){
        $name = trim($_POST['name'] ?? '');
        $slug = trim($_POST['slug'] ?? '');
        if($name===''){ $_SESSION['error']='Name is required'; return $res->redirect('/admin/categories/create'); }
        Category::create($name, $slug ?: preg_replace('/\s+/', '-', strtolower($name)));
        $_SESSION['flash']='Category created'; return $res->redirect('/admin/categories');
    }

    public function editForm($req,$res){
        $id = (int)($_GET['id'] ?? 0);
        $item = Category::find($id);
        if(!$item){ http_response_code(404); echo 'Not found'; return; }
        include __DIR__ . '/../../Views/admin/categories/edit.php';
    }

    public function update($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $slug = trim($_POST['slug'] ?? '');
        if($id<=0 || $name===''){ $_SESSION['error']='Invalid form'; return $res->redirect('/admin/categories'); }
        Category::update($id,$name,$slug);
        $_SESSION['flash']='Category updated'; return $res->redirect('/admin/categories');
    }

    public function delete($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        if($id>0){ Category::delete($id); $_SESSION['flash']='Category deleted'; }
        return $res->redirect('/admin/categories');
    }
}
